# Personalizace designu LCD panelu

Tato složka obsahuje HTML, CSS a JavaScript, který vykresluje informační systém v autobuse. Pokud se vyznáte ve webových technologiích, můžete si vzhled upravit podle svého.

## Důležité instrukce pro zachování kompatibility:

1. **Rozlišení:** Celková plocha musí zůstat **1920x540 px**. Toto rozlišení je pevně nastavené v aplikaci a DirectX textuře v OMSI.
2. **Rozvržení (50/50):** Design je navržen jako dvě poloviny. 
   - **Levá polovina (960x540 px):** Zastávkový seznam a hlášení.
   - **Pravá polovina (960x540 px):** Reklamní plocha a obrázky.
   - *Poznámka:* Doporučujeme držet se šířky panelů kolem **940-960 px**, aby se předešlo ořezání textu na okrajích monitoru v autobuse.
3. **ID Elementů:** Neměňte `id` existujících HTML elementů (např. `stop-list`, `next-stop-name`, `clock`), jinak aplikace nebude vědět, kam má zapisovat data z hry.
4. **JavaScript:** Funkce v `lcd.js` (zejména `window.lcdUpdateStops` a `window.lcdSetAds`) jsou klíčové pro komunikaci s OMSI. Pokud je smažete, LCD přestane reagovat na pohyb autobusu.
5. **Konfigurace modelu:** V `.cfg` souboru modelu autobusu musí být definováno minimálně **5 script textur**. Tato aplikace je natvrdo nastavena na zápis do **indexu 4** (tedy 5. textura v pořadí). Ujistěte se, že právě tato textura je v modelu přiřazena ploše širokého LCD panelu.

## Tipy:
- Upravte soubor `index.html` v sekci `<style>` pro změnu barev, fontů nebo animací.
- Pokud chcete změnit logo společnosti, nahraďte soubor `logo_transdevprášky.png` jiným se stejným názvem, nebo upravte cestu v HTML.
- **Reklamy:** Do složky `ads/` v hlavním adresáři programu můžete nahrávat vlastní obrázky (JPG, PNG) nebo videa (WebM), které se budou automaticky střídat.

---
Vytvořeno jako součást OMSI LCD System.
